# Microbial Composition Analysis Tool

## Overview

The Microbial Composition Analysis Tool is a Python-based image analysis tool designed for quantifying and analyzing microbial composition in fluorescence microscopy images obtained through FISH (Fluorescence In Situ Hybridization) experiments.

## Features

- Quantification of different microbial color categories (e.g., purple, blue, green) in fluorescence microscopy images.
- Color categories are defined based on RGB parameters (e.g. ratios between colors).
- Calculation of percentages for each color category to provide insights into microbial distribution.
- Compatibility with images obtained through FISH procedures using specific probes.

## Getting Started

### Prerequisites

- Python 3.x
- [Python Imaging Library (PIL)](https://python-pillow.org/)
- File 'Image processing FISH.ipynb' contains the required functions to quantify the FISH images. 
